/** Plante sonore - Justine Gendreau
 *  Programme Muti */
/// librairies
import processing.sound.*;
import processing.video.*; 
import processing.serial.*;



// variables globales
PImage im; // une image
SoundFile[] son; // un son - un seul lecteur CD audio
Movie vid; // une vidéo - un seul lecteur DVD vidéo

// bouton image active ? // est-ce que l'image est active ? Si oui, on affiche l'image
boolean animation_active = false; // true ou false (2 valleurs possibles) => 1 bit (0 ou 1)

// bouton son actif ?
boolean son_actif = false;
float tempsDebutSon = 0; // temps du début de la musique a été joué

// bouton videos active ?
boolean video_active[];

/// dialogue avec la carte Arduino
Serial myPort;  // Create object from Serial class
int  inBuffer;      // Data received from the serial port
int donneePortSerie; // entier converti de la chaine de caractère reçue sur le port série

// seuil de détection
float seuil = 300;

// port serie
int nPlantes = 8;///////////////////// METTRE LE BON NOMBRE DE CAPTEURS /////////////// 
int[] serialInArray = new int[nPlantes];    // Where we'll put what we receive
int serialCount = 0;                 // A count of how many bytes we receive
int[] plante;                 // valeur lue pour chaque plante via le port série et Arduino
boolean firstContact = false;        // Whether we've heard from the microcontroller

// média associés aux plantes
String[] nomSonPlante;
String[] nomvideosPlante;


void setup() { // initialisation des paramètres d'affichage & chargement des sons, vidéos, etc.
  size(1300, 860);
  noStroke();
  background(0);

  // initialisation des variables globale
  im = loadImage("images/chien.jpg");

  // création et initialisation de tableau de valeur "plantes"
  plante = new int[nPlantes];
  for (int i=0; i<nPlantes; i++) {
    plante[i] = 0;
  }

  // son des plantes
  nomSonPlante = new String[nPlantes];
  //for (int i = 0; i<nPlantes; i++) {
  //  nomSonPlante[0] = "sons/inst"+(i+1) + ".mp3";
  //}
  nomSonPlante[0]= "sons/inst1.mp3"; 
  nomSonPlante[1]= "sons/inst3.mp3";
  nomSonPlante[2]= "sons/silence.mp3";
  nomSonPlante[3]= "sons/inst4.mp3";
  nomSonPlante[4]= "sons/inst5.mp3";
  nomSonPlante[5]= "sons/inst6.mp3";
  nomSonPlante[6]= "sons/inst7.mp3";
  nomSonPlante[7]= "sons/inst8.mp3";

  // chargement des sons
  son =new SoundFile[nPlantes];
  for (int i=0; i<nPlantes; i++) {
    son[i] = new SoundFile(this, nomSonPlante[i]);
  }

  // videos des plantes
  nomvideosPlante = new String[nPlantes];
  nomvideosPlante[0]= "videos/noir.mp4"; 
  nomvideosPlante[1]= "videos/noir.mp4";
  nomvideosPlante[2]= "videos/plante.mp4";
  nomvideosPlante[3]= "videos/noir.mp4";
  nomvideosPlante[4]= "videos/noir.mp4"; 
  nomvideosPlante[5]= "videos/noir.mp4";
  nomvideosPlante[6]= "videos/noir.mp4";
  nomvideosPlante[7]= "videos/noir.mp4";
  
  video_active = new boolean[nPlantes];
  for (int i=0; i<nPlantes; i++) {
    video_active[i]=false;
  }



  //println(son.duration());

  // chargement de la videos
  vid = new Movie(this, "videos/affiche.mp4");

  /// Port série
  // Print a list of the serial ports, for debugging purposes:
  printArray(Serial.list());

  String portName = Serial.list()[2];
  myPort = new Serial(this, portName, 9600);
}

void draw() {


  // print the values (for debugging purposes only):
  println("plante[0]=" +plante[0] + "  plante[1]=" +plante[1]  + "  plante[2]=" +plante[2]+ "  son[0].isPlaying()=" + son[0].isPlaying()
    + "  plante[3]=" +plante[3]  // + "\t" +"plante[4]= " +plante[4]  + "\t" +"plante[5]= " +plante[5]  + "\t" +"plante[6]= " +plante[6]  + "\t" + "plante[7]= " +plante[7] + "\t" 
    + "  video[0]=" + video_active[0]+ " video[1]= " + video_active[1]  + "  video[2]= " + video_active[2] + "  video[3]= " + video_active[3]);

  //printArray(plante);
  //printArray(video_active);

  ///////////////////////// interactivités liées aux plantes
  for (int i=0; i<nPlantes; i++) { // pour chacune des plantes
    gestionSonPlante(i);
    gestionVideoPlante(i, nomvideosPlante[i]);
  }

  //// affichage de la vidéo si la vidéo i est active ////////////////////////////////////////
  boolean une_video_active=false;
  for (int i=0; i<nPlantes; i++) {
    une_video_active = (une_video_active || video_active[i]);
  }

  if (une_video_active) {
    image(vid, 0, 0, width, height);
  } else {
    background(0); // fond noir
  }




  // affichage de l'animation//////////////////////////////////////
  //if (animation_active) {
  //  lancerAnimation();
  //}
}
